
class ProfileModel {
  String companyRepresentativeId;
  String customerId;
  String firstname;
  String lastname;
  String position;
  String phone;
  String contactOther;
  String idCard;

  ProfileModel({
    this.companyRepresentativeId,
    this.customerId,
    this.firstname,
    this.lastname,
    this.position,
    this.phone,
    this.contactOther,
    this.idCard,
  });

  factory ProfileModel.fromJson(Map<String, dynamic> json) {
    return ProfileModel(
      companyRepresentativeId: json["CompanyRepresentativeID"] ?? "",
      customerId: json["customerId"] ?? "",
      firstname: json["contactName"] ?? "",
      lastname: json["contactSurName"] ?? "",
      position: json["Position"] ?? "",
      phone: json["Phone"] ?? "",
      contactOther: json["ChannelContact"] ?? "",
      idCard: json["citizenNumber"] ?? "",
    );
  }
  Map<String, dynamic> toJson() => {
        "CompanyRepresentativeID": companyRepresentativeId,
        "customerId": customerId,
        "contactName": firstname,
        "contactSurName": lastname,
        "Position": position,
        "Phone": phone,
        "ChannelContact": contactOther,
        "citizenNumber": idCard,
      };
}
