class HistoryBillDetailModel {
  String sequenceNumber;
  String itemName;
  String amount;
  String unit;

  HistoryBillDetailModel({
    this.sequenceNumber,
    this.itemName,
    this.amount,
    this.unit,
  });

  factory HistoryBillDetailModel.fromJson(Map<String, dynamic> json) => HistoryBillDetailModel(
        sequenceNumber: json["SequenceNumber"].toString(),
        itemName: json["ItemName"],
        amount: json["Amount"].toString(),
        unit: json["Unit"],
      );

  Map<String, dynamic> toJson() => {
        "SequenceNumber": sequenceNumber,
        "ItemName": itemName,
        "Amount": amount,
        "Unit": unit,
      };
}
