class FeedbackModel {
  String id;
  String date;
  String feedbackNumber;
  String feedbackType;
  String suggestionType;
  String branch;
  String status;

  FeedbackModel({
    this.id,
    this.date,
    this.feedbackNumber,
    this.feedbackType,
    this.suggestionType,
    this.branch,
    this.status,
  });
  factory FeedbackModel.fromJson(Map<String, dynamic> json) => FeedbackModel(
        id: json["ComplaintId"] ?? "",
        date: json["CreateDate"] ?? "",
        feedbackNumber: json["ComplaintNo"] ?? "",
        feedbackType: json["ComplaintTag"] ?? "",
        suggestionType: json["ComplaintType"] ?? "",
        branch: json["PeaName"] ?? "",
        status: json["ComplaintStatus"] ?? "",
      );

  Map<String, dynamic> toJson() => {
        "ComplaintId": id,
        "CreateDate": date,
        "ComplaintNo": feedbackNumber,
        "ComplaintTag": feedbackType,
        "ComplaintType": suggestionType,
        "PeaName": branch,
        "ComplaintStatus": status,
      };
}
