import 'package:peasmartcare/models/feedback_status_log_model.dart';
import 'package:peasmartcare/models/file_model.dart';

class FeedbackDetailModel {
  String id;
  String feedbackNumber;
  String feedbackTypeId;
  String feedbackTypeName;
  String name;
  String idCard;
  String phone;
  String email;
  String customerTypeId;
  String customerTypeName;
  String provinceId;
  String province;
  String branchCode;
  String branchName;
  String crimeScene;
  String caNumber;
  String contactLocation;
  String suggestionTypeId;
  String suggestionTypeName;
  String subjectSuggestionTypeId;
  String subjectSuggestionTypeName;
  String detail;
  String status;
  List<FileModel> attachmentFileList;
  List<FeedbackStatusLogModel> feedbackStatusLogList;

  FeedbackDetailModel({
    this.id,
    this.feedbackNumber,
    this.feedbackTypeId,
    this.feedbackTypeName,
    this.name,
    this.idCard,
    this.phone,
    this.email,
    this.customerTypeId,
    this.customerTypeName,
    this.provinceId,
    this.province,
    this.branchCode,
    this.branchName,
    this.crimeScene,
    this.caNumber,
    this.contactLocation,
    this.suggestionTypeId,
    this.suggestionTypeName,
    this.subjectSuggestionTypeId,
    this.subjectSuggestionTypeName,
    this.detail,
    this.status,
    this.attachmentFileList,
    this.feedbackStatusLogList,
  });
  factory FeedbackDetailModel.fromJson(Map<String, dynamic> json) => FeedbackDetailModel(
        id: json["ComplaintId"] ?? "",
        feedbackNumber: json["ComplaintNo"] ?? "",
        feedbackTypeId: json["tagId"].toString() ?? "",
        feedbackTypeName: json["tagName"] ?? "",
        name: json["complainerName"] ?? "",
        idCard: json["citizenNumber"] ?? "",
        phone: json["telephoneNumber"] ?? "",
        email: json["email"] ?? "",
        customerTypeId: json["customerTypeId"].toString() ?? "",
        customerTypeName: json["customerTypeName"] ?? "",
        provinceId: json["provinceId"].toString() ?? "",
        province: json["province"] ?? "",
        branchCode: json["peaCode"] ?? "",
        branchName: json["peaName"] ?? "",
        crimeScene: json["accidentLocation"] ?? "",
        caNumber: json["caNumber"] ?? "",
        contactLocation: json["contactAddress"] ?? "",
        suggestionTypeId: json["complaintTypeId"].toString() ?? "",
        suggestionTypeName: json["complaintTypeName"] ?? "",
        subjectSuggestionTypeId: json["complaintSubtypeId"].toString() ?? "",
        subjectSuggestionTypeName: json["complaintSubtypeName"] ?? "",
        detail: json["detail"] ?? "",
        status: json["ComplaintStatus"] ?? "",
        attachmentFileList: List<FileModel>.from(json["files"].map((x) => FileModel.fromJson(x))),
        feedbackStatusLogList: List<FeedbackStatusLogModel>.from(json["ComplaintLogList"].map((x) => FeedbackStatusLogModel.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "ComplaintId": id,
        "ComplaintNo": feedbackNumber,
        "tagId": feedbackTypeId,
        "tagName": feedbackTypeName,
        "complainerName": name,
        "citizenNumber": idCard,
        "telephoneNumber": phone,
        "email": email,
        "customerTypeId": customerTypeId,
        "customerTypeName": customerTypeName,
        "provinceId": provinceId,
        "province": province,
        "peaCode": branchCode,
        "peaName": branchName,
        "accidentLocation": crimeScene,
        "caNumber": caNumber,
        "contactAddress": contactLocation,
        "complaintTypeId": suggestionTypeId,
        "complaintTypeName": suggestionTypeName,
        "complaintSubtypeId": subjectSuggestionTypeId,
        "complaintSubtypeName": subjectSuggestionTypeName,
        "detail": detail,
        "status": status,
        "files": List<FileModel>.from(attachmentFileList.map((x) => x.toJson())),
        "ComplaintLogList": List<FeedbackStatusLogModel>.from(feedbackStatusLogList.map((x) => x.toJson())),
      };
}
