
class ElectricityStatisticModel {
  String name;
  double value;

  ElectricityStatisticModel({this.name, this.value});

  factory ElectricityStatisticModel.fromJson(Map<String, dynamic> json) => ElectricityStatisticModel(
        name: json["Text"] ?? "",
        value: double.parse((json["Value"] ?? "0").replaceAll(new RegExp(','), '')),
      );

  Map<String, dynamic> toJson() => {
        "Text": name,
        "Value": value,
      };
}
