class CoordinatorModel {
  String id;
  String idCard;
  String customerId;
  String fullname;
  String position;
  String phone;
  String otherContact;

  CoordinatorModel({
    this.id,
    this.idCard,
    this.customerId,
    this.fullname,
    this.position,
    this.phone,
    this.otherContact,
  });

  factory CoordinatorModel.fromJson(Map<String, dynamic> json) => CoordinatorModel(
        id: json["CustomerContactInfoId"] ?? "",
        idCard: json["CitizenNumber"] ?? "",
        customerId: json["CustomerID"] ?? "",
        fullname: json["ContactName"] ?? "",
        position: json["Position"] ?? "",
        phone: json["ContactTel"] ?? "",
        otherContact: json["ContactEtc"] ?? "",
      );

  Map<String, dynamic> toJson() => {
        "CustomerContactInfoId": id,
        "CitizenNumber": idCard,
        "CustomerID": customerId,
        "ContactName": fullname,
        "Position": position,
        "ContactTel": phone,
        "ContactEtc": otherContact,
      };
}
