class ChatUserModel {
  String id;
  String firstname;
  String lastname;
  String avatar;
  String idCard;
  String phone;
  String caNumber;
  String customerName;
  String customerAddress;

  ChatUserModel({
    this.id,
    this.firstname,
    this.lastname,
    this.avatar,
    this.idCard,
    this.phone,
    this.caNumber,
    this.customerName,
    this.customerAddress,
  });

  factory ChatUserModel.fromJson(Map<String, dynamic> json) => ChatUserModel(
        id: json["Id"],
        firstname: json["firstname"] ?? "",
        lastname: json["lastname"] ?? "",
        avatar: json["avatar"] ?? "",
        idCard: json["IDCard"] ?? "",
        phone: json["Mobile"] ?? "",
        caNumber: json["CA"] ?? "",
        customerName: json["CustomerName"] ?? "",
        customerAddress: json["CustomerAddress"] ?? "",
      );

  Map<String, dynamic> toJson() => {
        "Id": id,
        "firstname": firstname,
        "lastname": lastname,
        "avatar": avatar,
        "IDCard": idCard,
        "Mobile": phone,
        "CA": caNumber,
        "CustomerName": customerName,
        "CustomerAddress": customerAddress,
      };
}
