class ChatRoomModel {
  String id;
  String typeChat;
  String accountId;
  String chatMaster;
  String chatMasterId;
  String typeAccount;
  int memberCount;
  String customerId;
  String customerName;
  String caNumber;
  String customerAddress;
  String createDate;

  ChatRoomModel({
    this.id,
    this.typeChat,
    this.accountId,
    this.chatMaster,
    this.chatMasterId,
    this.typeAccount,
    this.memberCount,
    this.customerId,
    this.customerName,
    this.caNumber,
    this.customerAddress,
    this.createDate,
  });

  factory ChatRoomModel.fromJson(Map<String, dynamic> json) => ChatRoomModel(
        id: json["Id"],
        typeChat: json["TypeChat"] ?? "",
        accountId: json["AccountId"] ?? "",
        chatMaster: json["ChatMaster"] ?? "",
        chatMasterId: json["ChatMasterId"] ?? "",
        typeAccount: json["TypeAccount"] ?? "",
        memberCount: json["MemberCount"],
        customerId: json["CustomerId"] ?? "",
        customerName: json["CustomerName"] ?? "",
        caNumber: json["CA"] ?? "",
        customerAddress: json["CustomerAddress"] ?? "",
        createDate: json["CreateDate"] ?? "",
      );

  Map<String, dynamic> toJson() => {
        "Id": id,
        "TypeChat": typeChat,
        "AccountId": accountId,
        "ChatMaster": chatMaster,
        "ChatMasterId": chatMasterId,
        "TypeAccount": typeAccount,
        "MemberCount": memberCount,
        "CustomerId": customerId,
        "CustomerName": customerName,
        "CA": caNumber,
        "CustomerAddress": customerAddress,
        "CreateDate": createDate,
      };
}
