import 'dart:convert';

import 'package:html/parser.dart';

class AdditionalServiceModel {
  String id;
  String subject;
  String startDate;
  String endDate;
  String image;
  String detail;
  String detailBase64;
  int statusId;
  String statusName;

  AdditionalServiceModel({
    this.id,
    this.subject,
    this.startDate,
    this.endDate,
    this.image,
    this.detail,
    this.detailBase64,
    this.statusId,
    this.statusName,
  });

  factory AdditionalServiceModel.fromJson(Map<String, dynamic> json) {
    var documentDetail = parse(json["P_Detail"] ?? "");
    return AdditionalServiceModel(
      id: json["Id"] ?? "",
      subject: json["P_Name"] ?? "",
      startDate: json["StartDate"] ?? "",
      endDate: json["EndDate"] ?? "",
      image: json["ImageFile"],
      detail: json["P_Detail"] ?? "",
      // detail: parse(documentDetail.body.text).documentElement.text,
      detailBase64: base64Encode(const Utf8Encoder().convert((json["P_Detail"] ?? ""))),
      statusId: json["P_StatusType"] ?? "",
      statusName: json["Status"] ?? "",
    );
  }

  Map<String, dynamic> toJson() => {
        "Id": id,
        "P_Name": subject,
        "StartDate": startDate,
        "EndDate": endDate,
        "ImageFile": image,
        "P_Detail": detail,
        "P_StatusType": statusId,
        "Status": statusName,
      };
}
