import 'package:html/parser.dart';

class AdditionalServiceHistoryModel {
  String id;
  String prId;
  String subject;
  String startDate;
  String endDate;
  String image;
  String detail;
  int statusId;
  String statusName;
  String createBy;
  String createDate;

  AdditionalServiceHistoryModel({
    this.id,
    this.prId,
    this.subject,
    this.startDate,
    this.endDate,
    this.image,
    this.detail,
    this.statusId,
    this.statusName,
    this.createBy,
    this.createDate,
  });

  factory AdditionalServiceHistoryModel.fromJson(Map<String, dynamic> json) {
    var documentDetail = parse(json["P_Detail"] ?? "");
    return AdditionalServiceHistoryModel(
      id: json["P_Id"] ?? "",
      prId: json["PR_Id"] ?? "",
      subject: json["P_Name"] ?? "",
      startDate: json["strStartDate"] ?? "",
      endDate: json["strEndDate"] ?? "",
      image: json["ImageFile"],
      detail: parse(documentDetail.body.text).documentElement.text,
      statusId: json["PR_StatusType"],
      statusName: json["StatusType"] ?? "",
      createBy: json["CreateBy"] ?? "",
      createDate: json["strCreateDate"] ?? "",
    );
  }

  Map<String, dynamic> toJson() => {
        "P_Id": id,
        "PR_Id": prId,
        "P_Name": subject,
        "strStartDate": startDate,
        "strEndDate": endDate,
        "ImageFile": image,
        "P_Detail": detail,
        "P_StatusType": statusId,
        "Status": statusName,
        "CreateBy": createBy,
        "strCreateDate": createDate,
      };
}
