import 'package:firebase_core/firebase_core.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_downloader/flutter_downloader.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:peasmartcare/blocs/main_block_provider.dart';
import 'package:peasmartcare/blocs/simple_bloc_observer.dart';
import 'package:peasmartcare/components/splash_screen.dart';
import 'package:peasmartcare/pages/auth/authen.dart';
import 'package:peasmartcare/theme/style.dart';
import 'package:peasmartcare/utils/share_data_util.dart';
import 'package:peasmartcare/widgets/refresh_glowindicator.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';
import 'package:simple_splashscreen/simple_splashscreen.dart';

void main() async {
  WidgetsFlutterBinding.ensureInitialized();
  await ShareDataUtil.getInstance();
  await Firebase.initializeApp();
  Bloc.observer = SimpleBlocObserver();

  await FlutterDownloader.initialize(
      debug: true); // optional: set false to disable printing logs to console

  runApp(
    MainBlocProvider(
      child: MyApp(),
    ),
  );
}

class MyApp extends StatelessWidget {
  // This widget is the root of your application.
  @override
  Widget build(BuildContext context) {
    SystemChrome.setPreferredOrientations([
      DeviceOrientation.portraitUp,
    ]);

    return RefreshConfiguration(
      footerTriggerDistance: 15,
      dragSpeedRatio: 0.91,
      headerBuilder: () => MaterialClassicHeader(),
      footerBuilder: () => ClassicFooter(),
      enableLoadingWhenNoData: false,
      shouldFooterFollowWhenNotFull: (state) {
        // If you want load more with noMoreData state ,may be you should return false
        return false;
      },
      autoLoad: true,
      child: MaterialApp(
        localizationsDelegates: [
          GlobalMaterialLocalizations.delegate,
          GlobalWidgetsLocalizations.delegate,
          DefaultCupertinoLocalizations.delegate,
          GlobalCupertinoLocalizations
              .delegate, // Add global cupertino localiztions.
        ],
        locale: Locale('th', 'TH'), // Current locale
        supportedLocales: [
          const Locale('en', 'US'), // English
          const Locale('th', 'TH'), // Thai
        ],
        title: 'PEA Smart Care',
        debugShowCheckedModeBanner: false,
        builder: (context, child) {
          return ScrollConfiguration(
            child: child,
            behavior: RefreshScrollBehavior(),
          );
        },
        theme: appTheme(),
        home: MyHomePage(title: 'PEA Smart Care'),
      ),
    );
  }
}

class MyHomePage extends StatefulWidget {
  MyHomePage({Key key, this.title}) : super(key: key);

  final String title;

  @override
  _MyHomePageState createState() => _MyHomePageState();
}

class _MyHomePageState extends State<MyHomePage> {
  @override
  Widget build(BuildContext context) {
    return Simple_splashscreen(
      context: context,
      gotoWidget: AuthenPage(),
      // gotoWidget: LoginPage(),
      // gotoWidget: HomePage(),
      splashscreenWidget: SplashScreen(),
      timerInSeconds: 1,
    );
  }
}

//https://medium.com/@demmydwirhamadan/working-well-firebase-cloud-messaging-push-notification-in-flutter-tested-on-android-4eb91f45d45
