import 'package:flutter/material.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/chat_room/chat_room.dart';
import 'package:peasmartcare/pages/contact_staff/contact_staff.dart';
import 'package:peasmartcare/pages/notification/notification.dart';
import 'package:peasmartcare/widgets/fancy_bottom_navigation/fancy_bottom_navigation.dart';

class PEABottomBar extends StatefulWidget {
  final int initialActiveIndex;

  const PEABottomBar({Key key, this.initialActiveIndex = -1}) : super(key: key);
  @override
  _PEABottomBarState createState() => _PEABottomBarState();
}

class _PEABottomBarState extends State<PEABottomBar> {
  int currentPage = 0;
  bool isShowBadgeCount = false;

  // @override
  // void initState() {
  //   BlocProvider.of<BottomNavigationBloc>(context).add(
  //     BottomNavigationOnActive(activeIndex: currentPage),
  //   );
  //   super.initState();
  // }

  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    // currentPage = widget.initialActiveIndex;
    return FancyBottomNavigation(
      tabs: [
        TabData(
          imageIcon: Image.asset(ImageAsset.homeMenuImg, height: 30, fit: BoxFit.fitWidth),
          title: "หน้าหลัก",
        ),
        TabData(
          imageIcon: Image.asset(ImageAsset.notificationMenuImg, height: 30, fit: BoxFit.fitWidth),
          title: "แจ้งเตือน",
          // isShowBadgeCount: isShowBadgeCount,
          // badge: BlocBuilder<NotificationCountBloc, NotificationCountState>(
          //   builder: (context, state) {
          //     if (state is NotificationCountLoaded) {
          //       return state.result > 0
          //           ? Positioned(
          //               top: 0,
          //               right: 0,
          //               child: Container(
          //                 padding: EdgeInsets.all(1),
          //                 decoration: BoxDecoration(
          //                   color: Colors.red,
          //                   borderRadius: BorderRadius.circular(50),
          //                 ),
          //                 constraints: BoxConstraints(
          //                   minWidth: 25,
          //                   minHeight: 25,
          //                 ),
          //                 child: Text(
          //                   state.result > 99 ? "99+" : state.result.toString(),
          //                   style: TextStyle(
          //                     color: Colors.white,
          //                     fontSize: 15,
          //                   ),
          //                   textAlign: TextAlign.center,
          //                 ),
          //               ),
          //             )
          //           : SizedBox(
          //               height: 25,
          //               width: 25,
          //             );
          //     }

          //     return EmptyBox(heightFactor: 0);
          //   },
          // ),
        ),
        TabData(
          imageIcon: Image.asset(ImageAsset.contactMenuImg, height: 30, fit: BoxFit.fitWidth),
          title: 'ติดต่อ',
        ),
        TabData(
          imageIcon: Image.asset(ImageAsset.chatRoomMenuImg, height: 30, fit: BoxFit.fitWidth),
          title: 'แชท',
        ),
      ],
      barBackgroundColor: Color(AppData.purpleColor),
      circleColor: Color(AppData.whiteColor),
      textColor: Color(AppData.whiteColor),
      initialSelection: widget.initialActiveIndex,
      onTabChangedListener: (position) {
        // setState(() {
        //   currentPage = position;
        // });

        // BlocProvider.of<BottomNavigationBloc>(context).add(
        //   BottomNavigationOnActive(activeIndex: position),
        // );

        switch (position) {
          case 0:
            {
              Navigator.of(context).popUntil((route) => route.isFirst);
            }
            break;

          case 1:
            {
              Navigator.of(context).popUntil((route) => route.isFirst);
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => NotificationPage()),
              );
            }
            break;
          case 2:
            {
              Navigator.of(context).popUntil((route) => route.isFirst);
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => ContactStaffPage()),
              );
            }
            break;
          case 3:
            {
              Navigator.of(context).popUntil((route) => route.isFirst);
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => ChatRoomPage()),
              );
            }
            break;

          default:
            {
              Navigator.of(context).popUntil((route) => route.isFirst);
            }
            break;
        }
      },
    );
    // return BlocListener<BottomNavigationBloc, BottomNavigationState>(
    //   listener: (context, state) {
    //     if (state is BottomNavigationLoaded) {}
    //   },
//       child: BlocBuilder<BottomNavigationBloc, BottomNavigationState>(
//         builder: (context, state) {
//           if (state is BottomNavigationLoaded) {
//             int activeIndex = state.activeIndex;
//             return FancyBottomNavigation(
//               tabs: [
//                 TabData(
//                   imageIcon: Image.asset(ImageAsset.homeMenuImg, height: 30, fit: BoxFit.fitWidth),
//                   title: "หน้าหลัก",
//                 ),
//                 TabData(
//                   imageIcon: Image.asset(ImageAsset.notificationMenuImg, height: 30, fit: BoxFit.fitWidth),
//                   title: "แจ้งเตือน",
//                 ),
//                 TabData(
//                   imageIcon: Image.asset(ImageAsset.contactMenuImg, height: 30, fit: BoxFit.fitWidth),
//                   title: 'ติดต่อ',
//                 ),
//                 TabData(
//                   imageIcon: Image.asset(ImageAsset.chatRoomMenuImg, height: 30, fit: BoxFit.fitWidth),
//                   title: 'แชท',
//                 ),
//               ],
//               barBackgroundColor: Color(AppData.purpleColor),
//               circleColor: Color(AppData.whiteColor),
//               textColor: Color(AppData.whiteColor),
//               initialSelection: activeIndex,
//               onTabChangedListener: (position) {
//                 // setState(() {
//                 //   currentPage = position;
//                 // });

// print("===============");
//                 print(position);
// print("===============");
//                 BlocProvider.of<BottomNavigationBloc>(context).add(
//                   BottomNavigationOnActive(activeIndex: position),
//                 );

//                 switch (position) {
//                   case 0:
//                     {
//                       Navigator.of(context).popUntil((route) => route.isFirst);
//                     }
//                     break;

//                   case 1:
//                     {
//                       print(position);
//                     }
//                     break;
//                   case 2:
//                     {
//                       print(position);
//                     }
//                     break;
//                   case 3:
//                     {
//                       Navigator.of(context).popUntil((route) => route.isFirst);
//                       Navigator.push(
//                         context,
//                         MaterialPageRoute(builder: (context) => ChatRoomPage()),
//                       );
//                     }
//                     break;

//                   default:
//                     {
//                       Navigator.of(context).popUntil((route) => route.isFirst);
//                     }
//                     break;
//                 }
//               },
//             );
//           } else if (state is BottomNavigationError) {
//             return ErrorBox(
//               message: state.message,
//             );
//           }

//           return EmptyBox();
//         },
//       ),
//     );
  }
}
