import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/material.dart';
import 'package:peasmartcare/constraints/app_data.dart';

class HeaderContent extends StatefulWidget {
  final dynamic title;
  final String secondTitle;
  final String icon;
  final double height;
  final double fontSize;
  final int maxLines;

  const HeaderContent({
    Key key,
    @required this.title,
    this.secondTitle,
    @required this.icon,
    this.height,
    this.fontSize,
    this.maxLines,
  })  : assert(title != null),
        assert(icon != null),
        super(key: key);
  @override
  _HeaderContentState createState() => _HeaderContentState();
}

class _HeaderContentState extends State<HeaderContent> {
  @override
  Widget build(BuildContext context) {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      width: double.infinity,
      child: Stack(
        children: <Widget>[
          Opacity(
            opacity: 0.5,
            child: Card(
              color: Color(AppData.greyColor),
              child: Container(
                width: deviceSize.width,
                height: widget.height != null
                    ? widget.secondTitle == null
                        ? widget.height - 20
                        : widget.height
                    : widget.secondTitle == null ? 130 : 150,
              ),
            ),
          ),
          Positioned(
            top: 25,
            left: 5,
            child: Padding(
              padding: const EdgeInsets.only(left: 10, right: 10),
              child: Stack(
                children: <Widget>[
                  Container(
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(10),
                      gradient: LinearGradient(
                        colors: [
                          const Color(AppData.yellowColor),
                          const Color(AppData.whiteColor),
                        ],
                        begin: const FractionalOffset(0.0, 0.0),
                        end: const FractionalOffset(2.0, 0.0),
                        // stops: [0.0, 2.0],
                        // tileMode: TileMode.repeated,
                      ),
                    ),
                    width: 35,
                    height: 35,
                  ),
                  Image.asset(
                    widget.icon,
                    height: 40,
                  ),
                ],
              ),
            ),
          ),
          Positioned(
            top: widget.secondTitle == null ? 25 : 10,
            left: 55,
            child: Container(
              width: deviceSize.width - 55,
              padding: const EdgeInsets.only(left: 10, right: 10),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  (widget.title is Widget)
                      ? widget.title
                      : AutoSizeText(
                          widget.title ?? "",
                          style: TextStyle(
                            color: Color(AppData.yellowColor),
                            fontWeight: FontWeight.bold,
                            fontSize:
                                widget.fontSize == null ? 24 : widget.fontSize,
                          ),
                          maxLines:
                              widget.maxLines == null ? 1 : widget.maxLines,
                        ),
                  Text(
                    widget.secondTitle ?? "",
                    style: TextStyle(
                      color: Color(AppData.whiteColor),
                      fontWeight: FontWeight.bold,
                      fontSize: 20,
                    ),
                  ),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }
}
