import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/customer_info/customer_info_bloc.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/models/customer_info_model.dart';
import 'package:peasmartcare/pages/select_electricity_location/select_electricity_location.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:peasmartcare/widgets/error_box.dart';
import 'package:peasmartcare/widgets/loading.dart';

class CustomerInfo extends StatefulWidget {
  @override
  _CustomerInfoState createState() => _CustomerInfoState();
}

class _CustomerInfoState extends State<CustomerInfo> {
  @override
  void initState() {
    context.read<CustomerInfoBloc>().add(CustomerInfoGetData());
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.fromLTRB(10, 20, 10, 20),
      child: BlocListener<CustomerInfoBloc, CustomerInfoState>(
        listener: (context, state) {
          if (state is CustomerInfoError) {
            Navigator.push(
              context,
              MaterialPageRoute(builder: (context) => SelectElectricityLocationPage(isFromHome: true)),
            );
          }
        },
        child: BlocBuilder<CustomerInfoBloc, CustomerInfoState>(
          builder: (context, state) {
            if (state is CustomerInfoLoading) {
              return Loading();
            } else if (state is CustomerInfoLoaded) {
              CustomerInfoModel userInfo = state.result;
              return _buildTable(userInfo);
            } else if (state is CustomerInfoError) {
              return EmptyBox();
              // return ErrorBox(
              //   message: state.message,
              // );
            }

            return EmptyBox();
          },
        ),
      ),
    );
  }

  Widget _buildTable(CustomerInfoModel userInfo) {
    Size deviceSize = MediaQuery.of(context).size;
    TextStyle textLableStyle = TextStyle(fontSize: 16, color: Color(AppData.whiteColor));
    TextStyle textValueYellowStyle = TextStyle(fontSize: 16, color: Color(AppData.yellowColor), fontWeight: FontWeight.bold);
    TextStyle textValueStyle = TextStyle(fontSize: 14, color: Color(AppData.whiteColor));

    double minMaxHeightTwoLine = deviceSize.width > 500 ? 25 : 55;
    int maxLineBox = deviceSize.width > 500 ? 1 : 2;
    int maxLineAddressBox = deviceSize.width > 500 ? 1 : 3;

    return Column(
      // crossAxisAlignment: CrossAxisAlignment.center,
      children: [
        Center(
          child: Text(
            userInfo?.customerName ?? "",
            style: textLableStyle,
            textAlign: TextAlign.center,
          ),
        ),
        Table(
          columnWidths: {0: FixedColumnWidth(deviceSize.width / 2.35)},
          children: [
            TableRow(
              children: [
                TableCell(
                  verticalAlignment: TableCellVerticalAlignment.middle,
                  child: Padding(
                    padding: const EdgeInsets.only(right: 15),
                    child: Text(
                      "หมายเลขผู้ใช้ไฟฟ้า",
                      textAlign: TextAlign.right,
                      style: textLableStyle,
                    ),
                  ),
                ),
                TableCell(
                  child: Container(
                    alignment: Alignment.centerLeft,
                    constraints: BoxConstraints(minHeight: 25, maxHeight: 25),
                    width: deviceSize.width,
                    child: Row(
                      children: [
                        AutoSizeText(
                          userInfo.caNumber,
                          style: textValueYellowStyle,
                          maxLines: 1,
                        ),
                        SizedBox(width: 5),
                        ButtonTheme(
                          minWidth: 30,
                          height: 30,
                          child: RaisedButton(
                            color: Colors.blue[400],
                            child: Text(
                              "เปลี่ยน",
                              style: TextStyle(
                                color: Color(AppData.whiteColor),
                              ),
                            ),
                            onPressed: () {
                              Navigator.push(
                                context,
                                MaterialPageRoute(builder: (context) => SelectElectricityLocationPage(isFromHome: true)),
                              );
                            },
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ],
            ),
            TableRow(
              children: [
                TableCell(
                  verticalAlignment: TableCellVerticalAlignment.middle,
                  child: Padding(
                    padding: const EdgeInsets.only(right: 15),
                    child: Text(
                      "ที่อยู่บริษัท",
                      textAlign: TextAlign.right,
                      style: textLableStyle,
                    ),
                  ),
                ),
                TableCell(
                  child: Container(
                    alignment: Alignment.centerLeft,
                    constraints: BoxConstraints(minHeight: minMaxHeightTwoLine, maxHeight: minMaxHeightTwoLine),
                    width: deviceSize.width,
                    child: AutoSizeText(
                      userInfo.address,
                      style: textValueStyle,
                      maxLines: maxLineAddressBox,
                    ),
                  ),
                ),
              ],
            ),
            TableRow(
              children: [
                TableCell(
                  verticalAlignment: TableCellVerticalAlignment.top,
                  child: Padding(
                    padding: const EdgeInsets.only(right: 15),
                    child: Text(
                      "TSIC",
                      textAlign: TextAlign.right,
                      style: textLableStyle,
                    ),
                  ),
                ),
                TableCell(
                  verticalAlignment: TableCellVerticalAlignment.top,
                  child: Container(
                    padding: EdgeInsets.all(0),
                    alignment: Alignment.centerLeft,
                    constraints: BoxConstraints(minHeight: minMaxHeightTwoLine, maxHeight: minMaxHeightTwoLine),
                    width: deviceSize.width,
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        AutoSizeText(
                          "${userInfo.tsit} | ${userInfo.tsitName}",
                          style: textValueStyle,
                          maxLines: maxLineBox,
                        ),
                      ],
                    ),
                  ),
                ),
              ],
            ),
            TableRow(
              children: [
                TableCell(
                  verticalAlignment: TableCellVerticalAlignment.middle,
                  child: Padding(
                    padding: const EdgeInsets.only(right: 15),
                    child: Text(
                      "การไฟฟ้า",
                      textAlign: TextAlign.right,
                      style: textLableStyle,
                    ),
                  ),
                ),
                TableCell(
                  child: Container(
                    alignment: Alignment.centerLeft,
                    constraints: BoxConstraints(minHeight: 25, maxHeight: 25),
                    width: deviceSize.width,
                    child: AutoSizeText(
                      "${userInfo.peaRegionId} | ${userInfo.peaRegion}",
                      style: textValueStyle,
                      maxLines: maxLineBox,
                    ),
                  ),
                ),
              ],
            ),
          ],
        ),
      ],
    );
  }
}
