import 'dart:isolate';
import 'dart:ui';

import 'package:ext_storage/ext_storage.dart';
import 'package:flutter/material.dart';
import 'package:flutter_downloader/flutter_downloader.dart';
import 'package:flutter_progress_hud/flutter_progress_hud.dart';
import 'package:fluttericon/entypo_icons.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/models/chat_message_model.dart';
import 'package:peasmartcare/utils/app_util.dart';

class ChatDownloadFile extends StatefulWidget {
  final ChatMessageModel chatMessage;
  final VoidCallback onTap;

  const ChatDownloadFile({Key key, this.chatMessage, this.onTap}) : super(key: key);
  @override
  _ChatDownloadFileState createState() => _ChatDownloadFileState();
}

class _ChatDownloadFileState extends State<ChatDownloadFile> {
  ChatMessageModel item;
  ReceivePort _port = ReceivePort();
  String sendPort = "downloader_send_port";
  bool isolateNameServer = false;

  @override
  void initState() {
    item = widget.chatMessage;
    FlutterDownloader.registerCallback(downloadCallback);
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    // final progressModal = ProgressHUD.of(context);

    return InkWell(
      child: Container(
        width: 200,
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            Icon(
              Entypo.download,
              color: Color(AppData.whiteColor),
              size: 16,
            ),
            SizedBox(width: 15),
            Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(
                  "โหลดเอกสารแนบ",
                  overflow: TextOverflow.ellipsis,
                  style: TextStyle(
                    color: Color(AppData.whiteColor),
                    // fontSize: 12,
                  ),
                ),
                if (!AppUtil.isNil(item?.fileName))
                  Container(
                    width: 120,
                    child: Text(
                      item?.fileName,
                      overflow: TextOverflow.ellipsis,
                      maxLines: 3,
                      softWrap: false,
                      style: TextStyle(
                        color: Color(AppData.whiteColor),
                        // fontSize: 12,
                      ),
                    ),
                  ),
              ],
            ),
          ],
        ),
        margin: EdgeInsets.only(bottom: 10.0, right: 5),
        constraints: BoxConstraints(maxWidth: 250),
        padding: EdgeInsets.fromLTRB(15.0, 10.0, 15.0, 10.0),
        decoration: BoxDecoration(
          color: Color(AppData.greyColor),
          borderRadius: BorderRadius.circular(15),
        ),
      ),
      onTap: widget.onTap != null ? widget.onTap : () {},
    );
  }

  static void downloadCallback(String id, DownloadTaskStatus status, int progress) {
    final SendPort send = IsolateNameServer.lookupPortByName('downloader_send_port');

    send.send([id, status, progress]);
  }
}
