import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/utils/app_util.dart';
import 'package:peasmartcare/widgets/empty_box.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class BodyLayout extends StatefulWidget {
  final header;
  final dynamic headerImage;
  final child;
  final double top;
  final Color color;
  final RefreshCallback onPullRefresh;
  final LayoutType layoutType;
  final RefreshController refreshController;

  const BodyLayout({
    Key key,
    this.header,
    this.headerImage,
    @required this.child,
    this.top = 250,
    this.onPullRefresh,
    this.color,
    this.layoutType = LayoutType.DEFAULT,
    this.refreshController,
  }) : super(key: key);

  @override
  _BodyLayoutState createState() => _BodyLayoutState();
}

class _BodyLayoutState extends State<BodyLayout> {
  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    if (widget.onPullRefresh != null) {
      return LayoutBuilder(
        builder: (BuildContext context, BoxConstraints constraints) {
          return SmartRefresher(
            enablePullDown: true,
            enablePullUp: false,
            header: WaterDropMaterialHeader(color: Color(AppData.whiteColor), backgroundColor: Color(AppData.yellowColor)),
            controller: widget.refreshController,
            onRefresh: widget.onPullRefresh ?? _onRefresh,
            onLoading: _onLoading,
            child: _defaultContainer(constraints),
          );
        },
      );
    } else {
      return LayoutBuilder(
        builder: (BuildContext context, BoxConstraints constraints) {
          return _defaultContainer(constraints);
        },
      );
    }
  }

  Widget _header() {
    Size deviceSize = MediaQuery.of(context).size;
    switch (widget.layoutType) {
      case LayoutType.HEADER_IMAGE:
        {
          return Positioned(
            child: Stack(
              children: <Widget>[
                Container(
                  alignment: Alignment.topCenter,
                  child: widget.headerImage != null
                      ? !(widget.headerImage is Widget)
                          ? CachedNetworkImage(
                              imageUrl: widget.headerImage,
                              // placeholder: (context, url) => CircularProgressIndicator(),
                              errorWidget: (context, url, error) => Icon(Icons.error),
                              fit: BoxFit.fitWidth,
                            )
                          : widget.headerImage
                      : EmptyBox(heightFactor: 0),
                ),
                widget.header != null ? widget.header : EmptyBox(heightFactor: 0),
              ],
            ),
          );
        }
        break;

      case LayoutType.ONLY_CHILD:
        {
          return Positioned(
            child: Stack(
              children: <Widget>[
                Container(
                  alignment: Alignment.topCenter,
                  child: Image.asset(
                    ImageAsset.bgBodyTop,
                    // height: deviceSize.height * 0.43,
                    width: deviceSize.width,
                    fit: BoxFit.fill,
                  ),
                ),
              ],
            ),
          );
        }
        break;

      default:
        {
          return Positioned(
            child: Stack(
              children: <Widget>[
                Container(
                  alignment: Alignment.topCenter,
                  child: Image.asset(
                    ImageAsset.bgBodyTop,
                    height: deviceSize.height * 0.43,
                    width: deviceSize.width,
                    fit: BoxFit.fill,
                  ),
                ),
                widget.header,
              ],
            ),
          );
        }
        break;
    }
  }

  Widget _defaultContainer(constraints) {
    Size deviceSize = MediaQuery.of(context).size;

    return Container(
      color: widget.color ?? Colors.purple[50],
      child: SingleChildScrollView(
        child: ConstrainedBox(
          constraints: constraints.copyWith(
            minHeight: constraints.maxHeight,
            maxHeight: double.infinity,
          ),
          child: Stack(
            children: <Widget>[
              Container(
                color: widget.color ?? Colors.white,
              ),
              Positioned(
                bottom: (deviceSize.height * 0.43) - deviceSize.height * 0.43,
                child: Container(
                  alignment: Alignment.bottomCenter,
                  child: Image.asset(
                    ImageAsset.bgBodyBottom,
                    height: deviceSize.height * 0.43,
                    width: deviceSize.width,
                    fit: BoxFit.fill,
                  ),
                ),
              ),
              Container(
                alignment: Alignment.topCenter,
                child: IntrinsicHeight(
                  child: Stack(
                    children: <Widget>[
                      _header(),
                      SizedBox(height: 55),
                      Positioned(
                        child: Padding(
                          padding: EdgeInsets.only(top: widget.header != null ? AppUtil.bodyLayoutTopDefault(context) : widget.top),
                          child: Column(
                            children: <Widget>[widget.child, SizedBox(height: 30)],
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
                //   ),
                // ),
              ),
            ],
          ),
        ),
      ),
    );
  }

  // Widget _pullRefreshContainer(constraints) {
  //   Size deviceSize = MediaQuery.of(context).size;
  //   return Container(
  //     child: Stack(
  //       children: <Widget>[
  //         Container(
  //           color: widget.color ?? Colors.white,
  //         ),
  //         Positioned(
  //           bottom: 0,
  //           child: Container(
  //             alignment: Alignment.bottomCenter,
  //             child: Image.asset(
  //               ImageAsset.bgBodyBottom,
  //               height: deviceSize.height * 0.43,
  //               width: deviceSize.width,
  //               fit: BoxFit.fill,
  //             ),
  //           ),
  //         ),
  //         Container(
  //           alignment: Alignment.topCenter,
  //           child: SingleChildScrollView(
  //             child: ConstrainedBox(
  //               constraints: constraints.copyWith(
  //                 minHeight: constraints.maxHeight,
  //                 maxHeight: double.infinity,
  //               ),
  //               child: IntrinsicHeight(
  //                 child: Stack(
  //                   children: <Widget>[
  //                     _header(),
  //                     Positioned(
  //                       child: Padding(
  //                         padding: EdgeInsets.only(top: widget.top),
  //                         child: widget.child,
  //                       ),
  //                     ),
  //                   ],
  //                 ),
  //               ),
  //             ),
  //           ),
  //         ),
  //       ],
  //     ),
  //   );
  // }

  // Widget _pullRefreshContainerTemp(constraints) {
  //   Size deviceSize = MediaQuery.of(context).size;
  //   return Container(
  //     child: RefreshIndicator(
  //       onRefresh: widget.onPullRefresh ?? _onRefresh,
  //       child: Stack(
  //         children: <Widget>[
  //           Container(
  //             color: widget.color ?? Colors.white,
  //           ),
  //           Positioned(
  //             bottom: 0,
  //             child: Container(
  //               alignment: Alignment.bottomCenter,
  //               child: Image.asset(
  //                 ImageAsset.bgBodyBottom,
  //                 height: deviceSize.height * 0.43,
  //                 width: deviceSize.width,
  //                 fit: BoxFit.fill,
  //               ),
  //             ),
  //           ),
  //           Container(
  //             alignment: Alignment.topCenter,
  //             child: SingleChildScrollView(
  //               child: ConstrainedBox(
  //                 constraints: constraints.copyWith(
  //                   minHeight: constraints.maxHeight,
  //                   maxHeight: double.infinity,
  //                 ),
  //                 child: IntrinsicHeight(
  //                   child: Stack(
  //                     children: <Widget>[
  //                       _header(),
  //                       Positioned(
  //                         child: Padding(
  //                           padding: EdgeInsets.only(top: widget.top),
  //                           child: widget.child,
  //                         ),
  //                       ),
  //                     ],
  //                   ),
  //                 ),
  //               ),
  //             ),
  //           ),
  //         ],
  //       ),
  //     ),
  //   );
  // }

  Future<void> _onRefresh() async {}

  void _onLoading() async {
    // monitor network fetch
    await Future.delayed(Duration(milliseconds: 1000));
    // if failed,use loadFailed(),if no data return,use LoadNodata()

    // _refreshController.loadComplete();
  }
}

enum LayoutType { DEFAULT, ONLY_CHILD, HEADER_IMAGE }
