part of 'survey_subject_bloc.dart';

abstract class SurveySubjectState extends Equatable {
  const SurveySubjectState();

  @override
  List<Object> get props => [];
}

class SurveySubjectInitial extends SurveySubjectState {}

class SurveySubjectLoading extends SurveySubjectState {}

class SurveySubjectLoaded extends SurveySubjectState {
  final SurveySubjectModel result;

  SurveySubjectLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class SurveySubjectError extends SurveySubjectState {
  final String message;
  const SurveySubjectError({this.message});
  @override
  List<Object> get props => [message];
}

class SurveySubjectErrorUnauthorized extends SurveySubjectState {}
