part of 'survey_question_bloc.dart';

abstract class SurveyQuestionState extends Equatable {
  const SurveyQuestionState();
  @override
  List<Object> get props => [];
}

class SurveyQuestionInitial extends SurveyQuestionState {
  @override
  List<Object> get props => [];
}

class SurveyQuestionLoading extends SurveyQuestionState {}

class SurveyQuestionLoaded extends SurveyQuestionState {
  final SurveyQuestionModel result;
  final int currentIndex;
  final bool isNext;
  final String customerId;
  final bool saveSuccess;

  SurveyQuestionLoaded({
    this.result,
    this.currentIndex,
    this.isNext,
    this.customerId,
    this.saveSuccess,
  });
  @override
  List<Object> get props => [result, currentIndex, isNext, customerId, saveSuccess];
}

class SurveyQuestionNotFound extends SurveyQuestionState {}

class SurveyQuestionError extends SurveyQuestionState {
  final String message;
  const SurveyQuestionError({this.message});
  @override
  List<Object> get props => [message];
}

class SurveyQuestionErrorUnauthorized extends SurveyQuestionState {}
