import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/models/survey_answer_model.dart';
import 'package:peasmartcare/models/survey_question_model.dart';
import 'package:peasmartcare/services/survey_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'survey_question_event.dart';
part 'survey_question_state.dart';

class SurveyQuestionBloc extends Bloc<SurveyQuestionEvent, SurveyQuestionState> {
  SurveyImpService service = SurveyImpService();

  ResultData resultData;
  ResultData saveResultData;
  List<SurveyAnswerModel> answerList = List<SurveyAnswerModel>();
  String surveyId;
  int currentIndex = 0;
  int total = 0;

  SurveyQuestionBloc() : super(SurveyQuestionInitial());

  @override
  Stream<SurveyQuestionState> mapEventToState(SurveyQuestionEvent event) async* {
    try {
      if (event is SurveyQuestionAddSurveyId) {
        surveyId = event.surveyId;
      } else if (event is SurveyQuestionGetCurrentQuestion) {
        yield SurveyQuestionLoading();
        currentIndex = event.currentIndex;
        bool isNext = (currentIndex < (total - 1));

        if (currentIndex < 0)
          currentIndex = 0;
        else if (currentIndex > (total - 1)) currentIndex = (total - 1);

        await Future.delayed(Duration(milliseconds: 100));

        if (resultData.statusCode == 401) {
          yield SurveyQuestionErrorUnauthorized();
        } else {
          yield SurveyQuestionLoaded(
            result: resultData.result[currentIndex],
            currentIndex: currentIndex,
            isNext: isNext,
            customerId: ShareDataUtil.getCustomerId(),
            saveSuccess: null,
          );
        }
      } else if (event is SurveyQuestionAddAnswer) {
        SurveyAnswerModel answer = event.answer;
        // print(answer.questionId);
        // print(answer.choiceId);
        // print(answer.value);
        answerList.add(answer);
      } else if (event is SurveyQuestionSendAnswer) {
        yield SurveyQuestionLoading();

        saveResultData = await service.sendAnswer(answerList: answerList);

        yield SurveyQuestionLoaded(
          result: resultData.result[currentIndex],
          currentIndex: currentIndex,
          isNext: (currentIndex < (total - 1)),
          customerId: ShareDataUtil.getCustomerId(),
          saveSuccess: saveResultData.result,
        );
      } else if (event is SurveyQuestionGetList) {
        yield SurveyQuestionLoading();

        answerList = List<SurveyAnswerModel>();

        resultData = await service.getQuestion(
          surveyId: surveyId,
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        currentIndex = 0;
        total = resultData.result.length;

        if (total != 0) {
          yield SurveyQuestionLoaded(
            result: resultData.result[currentIndex],
            currentIndex: currentIndex,
            isNext: (currentIndex < (total - 1)),
            customerId: ShareDataUtil.getCustomerId(),
            saveSuccess: null,
          );
        } else {
          yield SurveyQuestionNotFound();
        }
      }
    } catch (e) {
      yield SurveyQuestionError(message: "Error");
    }
  }
}
