part of 'survey_list_bloc.dart';

abstract class SurveyListState extends Equatable {
  const SurveyListState();

  @override
  List<Object> get props => [];
}

class SurveyListInitial extends SurveyListState {
  @override
  List<Object> get props => [];
}

class SurveyListLoading extends SurveyListState {}

class SurveyListLoaded extends SurveyListState {
  final List<SurveyModel> result;
  final bool deleteSuccess;

  SurveyListLoaded({
    this.result,
    this.deleteSuccess,
  });
  @override
  List<Object> get props => [result, deleteSuccess];
}

class SurveyListNotFound extends SurveyListState {}

class SurveyListError extends SurveyListState {
  final String message;
  const SurveyListError({this.message});
  @override
  List<Object> get props => [message];
}

class SurveyListErrorUnauthorized extends SurveyListState {}
