part of 'report_incident_plan_list_bloc.dart';

abstract class ReportIncidentPlanListState extends Equatable {
  const ReportIncidentPlanListState();
  @override
  List<Object> get props => [];
}

class ReportIncidentPlanListInitial extends ReportIncidentPlanListState {
  @override
  List<Object> get props => [];
}

class ReportIncidentPlanListLoading extends ReportIncidentPlanListState {}

class ReportIncidentPlanListLoaded extends ReportIncidentPlanListState {
  final List<ReportIncidentPlanModel> result;
  final bool deleteSuccess;

  ReportIncidentPlanListLoaded({
    this.result,
    this.deleteSuccess,
  });
  @override
  List<Object> get props => [result, deleteSuccess];
}

class ReportIncidentPlanListNotFound extends ReportIncidentPlanListState {}

class ReportIncidentPlanListError extends ReportIncidentPlanListState {
  final String message;
  const ReportIncidentPlanListError({this.message});
  @override
  List<Object> get props => [message];
}

class ReportIncidentPlanListErrorUnauthorized extends ReportIncidentPlanListState {}
