import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/report_incident_plan_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/report_incident_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'report_incident_plan_list_event.dart';
part 'report_incident_plan_list_state.dart';

class ReportIncidentPlanListBloc extends Bloc<ReportIncidentPlanListEvent, ReportIncidentPlanListState> {
  ReportIncidentImpService service = ReportIncidentImpService();

  ResultData resultData;
  // List<ReportIncidentPlanModel> planList;

  ReportIncidentPlanListBloc() : super(ReportIncidentPlanListInitial());

  @override
  Stream<ReportIncidentPlanListState> mapEventToState(ReportIncidentPlanListEvent event) async* {
    try {
      if (event is ReportIncidentPlanListGetList) {
        yield ReportIncidentPlanListLoading();

        resultData = await service.getPlanList(
          customerId: ShareDataUtil.getCustomerId(),
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield ReportIncidentPlanListErrorUnauthorized();
        } else {
          yield ReportIncidentPlanListLoaded(result: resultData.result, deleteSuccess: null);
        }
      } else if (event is ReportIncidentPlanListOnDelete) {
        await Future.delayed(Duration(seconds: 2));

        if (resultData.statusCode == 401) {
          yield ReportIncidentPlanListErrorUnauthorized();
        } else {
          yield ReportIncidentPlanListLoaded(result: resultData.result, deleteSuccess: true);
        }
      }
    } catch (e) {
      yield ReportIncidentPlanListError(message: "Error");
    }
  }
}
