part of 'report_incident_create_bloc.dart';

abstract class ReportIncidentCreateState extends Equatable {
  const ReportIncidentCreateState();

  @override
  List<Object> get props => [];
}

class ReportIncidentCreateInitial extends ReportIncidentCreateState {
  @override
  List<Object> get props => [];
}

class ReportIncidentCreateLoading extends ReportIncidentCreateState {}

class ReportIncidentCreateLoaded extends ReportIncidentCreateState {
  final bool result;
  final List<ReportIncidentTypeModel> reportIncidentTypeList;
  final UserModel user;

  ReportIncidentCreateLoaded({
    this.result,
    this.reportIncidentTypeList,
    this.user,
  });
  @override
  List<Object> get props => [result, reportIncidentTypeList, user];
}

class ReportIncidentCreateNotFound extends ReportIncidentCreateState {}

class ReportIncidentCreateError extends ReportIncidentCreateState {
  final String message;
  const ReportIncidentCreateError({this.message});
  @override
  List<Object> get props => [message];
}

class ReportIncidentCreateErrorUnauthorized extends ReportIncidentCreateState {}
