part of 'register_bloc.dart';

abstract class RegisterEvent extends Equatable {
  const RegisterEvent();
  @override
  List<Object> get props => [];
}

class RegisterOnSubmit extends RegisterEvent {
  final String firstname;
  final String lastname;
  final String idCard;
  final String phone;
  final int cardTypeId;

  RegisterOnSubmit({
    @required this.firstname,
    @required this.lastname,
    @required this.idCard,
    @required this.phone,
    @required this.cardTypeId,
  })  : assert(firstname != null),
        assert(lastname != null),
        assert(idCard != null),
        assert(phone != null),
        assert(cardTypeId != null);

  @override
  List<Object> get props => [firstname, lastname, idCard, phone, cardTypeId];
}
