part of 'questionnaire_question_bloc.dart';

abstract class QuestionnaireQuestionState extends Equatable {
  const QuestionnaireQuestionState();
  @override
  List<Object> get props => [];
}

class QuestionnaireQuestionInitial extends QuestionnaireQuestionState {
  @override
  List<Object> get props => [];
}

class QuestionnaireQuestionLoading extends QuestionnaireQuestionState {}

class QuestionnaireQuestionLoaded extends QuestionnaireQuestionState {
  final QuestionnaireQuestionModel result;
  final int currentIndex;
  final bool isNext;
  final String customerId;
  final bool saveSuccess;

  QuestionnaireQuestionLoaded({
    this.result,
    this.currentIndex,
    this.isNext,
    this.customerId,
    this.saveSuccess,
  });
  @override
  List<Object> get props => [result, currentIndex, isNext, customerId, saveSuccess];
}

class QuestionnaireQuestionNotFound extends QuestionnaireQuestionState {}

class QuestionnaireQuestionError extends QuestionnaireQuestionState {
  final String message;
  const QuestionnaireQuestionError({this.message});
  @override
  List<Object> get props => [message];
}

class QuestionnaireQuestionErrorUnauthorized extends QuestionnaireQuestionState {}
