import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/questionnaire_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/questionnaire_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'questionnaire_list_event.dart';
part 'questionnaire_list_state.dart';

class QuestionnaireListBloc extends Bloc<QuestionnaireListEvent, QuestionnaireListState> {
  QuestionnaireImpService service = QuestionnaireImpService();

  ResultData resultData;

  QuestionnaireListBloc() : super(QuestionnaireListInitial());

  @override
  Stream<QuestionnaireListState> mapEventToState(QuestionnaireListEvent event) async* {
    try {
      if (event is QuestionnaireListGetList) {
        yield QuestionnaireListLoading();

        resultData = await service.getList(
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield QuestionnaireListErrorUnauthorized();
        } else {
          yield QuestionnaireListLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield QuestionnaireListError(message: "Error");
    }
  }
}
