part of 'profile_bloc.dart';

abstract class ProfileState extends Equatable {
  const ProfileState();

  @override
  List<Object> get props => [];
}

class ProfileInitial extends ProfileState {
  @override
  List<Object> get props => [];
}

class ProfileLoading extends ProfileState {}

class ProfileLoaded extends ProfileState {
  final ProfileModel result;
  final bool saveSuccess;

  ProfileLoaded({
    this.result,
    this.saveSuccess,
  });
  @override
  List<Object> get props => [result, saveSuccess];
}

class ProfileNotFound extends ProfileState {}

class ProfileError extends ProfileState {
  final String message;
  const ProfileError({this.message});
  @override
  List<Object> get props => [message];
}

class ProfileErrorUnauthorized extends ProfileState {}
