part of 'notification_list_bloc.dart';

abstract class NotificationListState extends Equatable {
  const NotificationListState();

  @override
  List<Object> get props => [];
}

class NotificationListInitial extends NotificationListState {
  @override
  List<Object> get props => [];
}

class NotificationListLoading extends NotificationListState {}

class NotificationListLoaded extends NotificationListState {
  final List<NotificationModel> result;

  NotificationListLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class NotificationListNotFound extends NotificationListState {}

class NotificationListError extends NotificationListState {
  final String message;
  const NotificationListError({this.message});
  @override
  List<Object> get props => [message];
}

class NotificationListErrorUnauthorized extends NotificationListState {}
