part of 'notification_bloc.dart';

abstract class NotificationState extends Equatable {
  const NotificationState();

  @override
  List<Object> get props => [];
}

class NotificationInitial extends NotificationState {
  @override
  List<Object> get props => [];
}

class NotificationLoading extends NotificationState {}

class NotificationLoaded extends NotificationState {
  final List<NotificationModel> result;
  final bool deleteSuccess;

  NotificationLoaded({
    this.result,
    this.deleteSuccess,
  });
  @override
  List<Object> get props => [result, deleteSuccess];
}

class NotificationNotFound extends NotificationState {}

class NotificationError extends NotificationState {
  final String message;
  const NotificationError({this.message});
  @override
  List<Object> get props => [message];
}

class NotificationErrorUnauthorized extends NotificationState {}
