part of 'news_list_bloc.dart';

abstract class NewsListState extends Equatable {
  const NewsListState();

  @override
  List<Object> get props => [];
}

class NewsListInitial extends NewsListState {
  @override
  List<Object> get props => [];
}

class NewsListLoading extends NewsListState {}

class NewsListLoaded extends NewsListState {
  final List<NewsModel> result;
  final bool deleteSuccess;

  NewsListLoaded({
    this.result,
    this.deleteSuccess,
  });
  @override
  List<Object> get props => [result, deleteSuccess];
}

class NewsListNotFound extends NewsListState {}

class NewsListError extends NewsListState {
  final String message;
  const NewsListError({this.message});
  @override
  List<Object> get props => [message];
}

class NewsListErrorUnauthorized extends NewsListState {}
