part of 'news_featured_list_bloc.dart';

abstract class NewsFeaturedListState extends Equatable {
  const NewsFeaturedListState();

  @override
  List<Object> get props => [];
}

class NewsFeaturedListInitial extends NewsFeaturedListState {
  @override
  List<Object> get props => [];
}

class NewsFeaturedListLoading extends NewsFeaturedListState {}

class NewsFeaturedListLoaded extends NewsFeaturedListState {
  final List<NewsModel> result;

  NewsFeaturedListLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class NewsFeaturedListNotFound extends NewsFeaturedListState {}

class NewsFeaturedListError extends NewsFeaturedListState {
  final String message;
  const NewsFeaturedListError({this.message});
  @override
  List<Object> get props => [message];
}

class NewsFeaturedListErrorUnauthorized extends NewsFeaturedListState {}
