import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/news_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/news_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'news_featured_list_event.dart';
part 'news_featured_list_state.dart';

class NewsFeaturedListBloc extends Bloc<NewsFeaturedListEvent, NewsFeaturedListState> {
  NewsImpService service = NewsImpService();

  ResultData resultData;

  NewsFeaturedListBloc() : super(NewsFeaturedListInitial());

  @override
  Stream<NewsFeaturedListState> mapEventToState(NewsFeaturedListEvent event) async* {
    try {
      if (event is NewsFeaturedListGetList) {
        yield NewsFeaturedListLoading();

        resultData = await service.getList(authenKey: ShareDataUtil.getAuthenKey());

        if (resultData.statusCode == 401) {
          yield NewsFeaturedListErrorUnauthorized();
        } else {
          yield NewsFeaturedListLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield NewsFeaturedListError(message: "Error");
    }
  }
}
