import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/activity_list/activity_list_bloc.dart';
import 'package:peasmartcare/blocs/additional_service_detail/additional_service_detail_bloc.dart';
import 'package:peasmartcare/blocs/additional_service_history/additional_service_history_bloc.dart';
import 'package:peasmartcare/blocs/additional_service_list/additional_service_list_bloc.dart';
import 'package:peasmartcare/blocs/authen/authen_bloc.dart';
import 'package:peasmartcare/blocs/bottom_navigation/bottom_navigation_bloc.dart';
import 'package:peasmartcare/blocs/chat_current_message_date/chat_current_message_date_bloc.dart';
import 'package:peasmartcare/blocs/chat_list/chat_list_bloc.dart';
import 'package:peasmartcare/blocs/chat_menu_badge_count/chat_menu_badge_count_bloc.dart';
import 'package:peasmartcare/blocs/chat_reader_list/chat_reader_list_bloc.dart';
import 'package:peasmartcare/blocs/chat_room_list/chat_room_list_bloc.dart';
import 'package:peasmartcare/blocs/contact_staff/contact_staff_list_bloc.dart';
import 'package:peasmartcare/blocs/coordinator_list/coordinator_list_bloc.dart';
import 'package:peasmartcare/blocs/coordinator_save/coordinator_save_bloc.dart';
import 'package:peasmartcare/blocs/customer_info/customer_info_bloc.dart';
import 'package:peasmartcare/blocs/electricity_location_current/electricity_location_current_bloc.dart';
import 'package:peasmartcare/blocs/electricity_location_list/electricity_location_list_bloc.dart';
import 'package:peasmartcare/blocs/electricity_location_save/electricity_location_save_bloc.dart';
import 'package:peasmartcare/blocs/electricity_statistic/electricity_statistic_bloc.dart';
import 'package:peasmartcare/blocs/electricity_statistic_pea_number_list/electricity_statistic_pea_number_list_bloc.dart';
import 'package:peasmartcare/blocs/electricity_statistic_type_list/electricity_statistic_type_list_bloc.dart';
import 'package:peasmartcare/blocs/feedback_detail/feedback_detail_bloc.dart';
import 'package:peasmartcare/blocs/feedback_list/feedback_list_bloc.dart';
import 'package:peasmartcare/blocs/feedback_province/feedback_province_bloc.dart';
import 'package:peasmartcare/blocs/feedback_save/feedback_save_bloc.dart';
import 'package:peasmartcare/blocs/feedback_suggestion_type/feedback_suggestion_type_bloc.dart';
import 'package:peasmartcare/blocs/feedback_type/feedback_type_bloc.dart';
import 'package:peasmartcare/blocs/history_bill_detail_list/history_bill_detail_list_bloc.dart';
import 'package:peasmartcare/blocs/history_bill_list/history_bill_list_bloc.dart';
import 'package:peasmartcare/blocs/home_app_bar/home_app_bar_bloc.dart';
import 'package:peasmartcare/blocs/login/login_bloc.dart';
import 'package:peasmartcare/blocs/logout/logout_bloc.dart';
import 'package:peasmartcare/blocs/news_detail/news_detail_bloc.dart';
import 'package:peasmartcare/blocs/news_featured_list/news_featured_list_bloc.dart';
import 'package:peasmartcare/blocs/news_list/news_list_bloc.dart';
import 'package:peasmartcare/blocs/notification/notification_bloc.dart';
import 'package:peasmartcare/blocs/notification_list/notification_list_bloc.dart';
import 'package:peasmartcare/blocs/profile/profile_bloc.dart';
import 'package:peasmartcare/blocs/questionnaire_list/questionnaire_list_bloc.dart';
import 'package:peasmartcare/blocs/questionnaire_question/questionnaire_question_bloc.dart';
import 'package:peasmartcare/blocs/register/register_bloc.dart';
import 'package:peasmartcare/blocs/report_incident_create/report_incident_create_bloc.dart';
import 'package:peasmartcare/blocs/report_incident_history_list/report_incident_history_list_bloc.dart';
import 'package:peasmartcare/blocs/report_incident_plan_list/report_incident_plan_list_bloc.dart';
import 'package:peasmartcare/blocs/resend_otp/resend_otp_bloc.dart';
import 'package:peasmartcare/blocs/select_electricity_location_list/select_electricity_location_list_bloc.dart';
import 'package:peasmartcare/blocs/select_electricity_location_save/select_electricity_location_save_bloc.dart';
import 'package:peasmartcare/blocs/survey_group_list/survey_group_list_bloc.dart';
import 'package:peasmartcare/blocs/survey_list/survey_list_bloc.dart';
import 'package:peasmartcare/blocs/survey_question/survey_question_bloc.dart';
import 'package:peasmartcare/blocs/survey_question_edit/survey_question_edit_bloc.dart';
import 'package:peasmartcare/blocs/survey_subject/survey_subject_bloc.dart';
import 'package:peasmartcare/blocs/timeline_list/timeline_list_bloc.dart';
import 'package:peasmartcare/blocs/verify_otp/verify_otp_bloc.dart';

class MainBlocProvider extends StatelessWidget {
  final Widget child;

  const MainBlocProvider({
    Key key,
    @required this.child,
  }) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return MultiBlocProvider(
      providers: [
        BlocProvider<HomeAppBarBloc>(
          create: (context) => HomeAppBarBloc(),
        ),
        BlocProvider<BottomNavigationBloc>(
          create: (context) => BottomNavigationBloc(),
        ),
        BlocProvider<AuthenBloc>(
          create: (context) => AuthenBloc(),
        ),
        BlocProvider<LoginBloc>(
          create: (context) => LoginBloc(),
        ),
        BlocProvider<LogoutBloc>(
          create: (context) => LogoutBloc(),
        ),
        BlocProvider<ProfileBloc>(
          create: (context) => ProfileBloc(),
        ),
        BlocProvider<CustomerInfoBloc>(
          create: (context) => CustomerInfoBloc(),
        ),
        BlocProvider<RegisterBloc>(
          create: (context) => RegisterBloc(),
        ),
        BlocProvider<ResendOtpBloc>(
          create: (context) => ResendOtpBloc(),
        ),
        BlocProvider<VerifyOtpBloc>(
          create: (context) => VerifyOtpBloc(),
        ),
        BlocProvider<HistoryBillListBloc>(
          create: (context) => HistoryBillListBloc(),
        ),
        BlocProvider<HistoryBillDetailListBloc>(
          create: (context) => HistoryBillDetailListBloc(),
        ),
        BlocProvider<FeedbackListBloc>(
          create: (context) => FeedbackListBloc(),
        ),
        BlocProvider<FeedbackDetailBloc>(
          create: (context) => FeedbackDetailBloc(),
        ),
        BlocProvider<FeedbackTypeBloc>(
          create: (context) => FeedbackTypeBloc(),
        ),
        BlocProvider<FeedbackProvinceBloc>(
          create: (context) => FeedbackProvinceBloc(),
        ),
        BlocProvider<FeedbackSuggestionTypeBloc>(
          create: (context) => FeedbackSuggestionTypeBloc(),
        ),
        BlocProvider<FeedbackSaveBloc>(
          create: (context) => FeedbackSaveBloc(),
        ),
        BlocProvider<ActivityListBloc>(
          create: (context) => ActivityListBloc(),
        ),
        BlocProvider<CoordinatorListBloc>(
          create: (context) => CoordinatorListBloc(),
        ),
        BlocProvider<CoordinatorSaveBloc>(
          create: (context) => CoordinatorSaveBloc(),
        ),
        BlocProvider<QuestionnaireListBloc>(
          create: (context) => QuestionnaireListBloc(),
        ),
        BlocProvider<QuestionnaireQuestionBloc>(
          create: (context) => QuestionnaireQuestionBloc(),
        ),
        BlocProvider<SurveyGroupListBloc>(
          create: (context) => SurveyGroupListBloc(),
        ),
        BlocProvider<SurveySubjectBloc>(
          create: (context) => SurveySubjectBloc(),
        ),
        BlocProvider<SurveyListBloc>(
          create: (context) => SurveyListBloc(),
        ),
        BlocProvider<SurveyQuestionBloc>(
          create: (context) => SurveyQuestionBloc(),
        ),
        BlocProvider<SurveyQuestionEditBloc>(
          create: (context) => SurveyQuestionEditBloc(),
        ),
        BlocProvider<TimelineListBloc>(
          create: (context) => TimelineListBloc(),
        ),
        BlocProvider<ChatRoomListBloc>(
          create: (context) => ChatRoomListBloc(),
        ),
        BlocProvider<ChatReaderListBloc>(
          create: (context) => ChatReaderListBloc(),
        ),
        BlocProvider<ChatListBloc>(
          create: (context) => ChatListBloc(),
        ),
        BlocProvider<ChatCurrentMessageDateBloc>(
          create: (context) => ChatCurrentMessageDateBloc(),
        ),
        BlocProvider<ElectricityLocationListBloc>(
          create: (context) => ElectricityLocationListBloc(),
        ),
        BlocProvider<ElectricityLocationCurrentBloc>(
          create: (context) => ElectricityLocationCurrentBloc(),
        ),
        BlocProvider<SelectElectricityLocationListBloc>(
          create: (context) => SelectElectricityLocationListBloc(),
        ),
        BlocProvider<ElectricityLocationSaveBloc>(
          create: (context) => ElectricityLocationSaveBloc(),
        ),
        BlocProvider<SelectElectricityLocationSaveBloc>(
          create: (context) => SelectElectricityLocationSaveBloc(),
        ),
        BlocProvider<NewsListBloc>(
          create: (context) => NewsListBloc(),
        ),
        BlocProvider<NewsFeaturedListBloc>(
          create: (context) => NewsFeaturedListBloc(),
        ),
        BlocProvider<NewsDetailBloc>(
          create: (context) => NewsDetailBloc(),
        ),
        BlocProvider<ElectricityStatisticBloc>(
          create: (context) => ElectricityStatisticBloc(),
        ),
        BlocProvider<ElectricityStatisticTypeListBloc>(
          create: (context) => ElectricityStatisticTypeListBloc(),
        ),
        BlocProvider<ElectricityStatisticPeaNumberListBloc>(
          create: (context) => ElectricityStatisticPeaNumberListBloc(),
        ),
        BlocProvider<ContactStaffListBloc>(
          create: (context) => ContactStaffListBloc(),
        ),
        BlocProvider<AdditionalServiceListBloc>(
          create: (context) => AdditionalServiceListBloc(),
        ),
        BlocProvider<AdditionalServiceHistoryBloc>(
          create: (context) => AdditionalServiceHistoryBloc(),
        ),
        BlocProvider<AdditionalServiceDetailBloc>(
          create: (context) => AdditionalServiceDetailBloc(),
        ),
        BlocProvider<ReportIncidentHistoryListBloc>(
          create: (context) => ReportIncidentHistoryListBloc(),
        ),
        BlocProvider<ReportIncidentPlanListBloc>(
          create: (context) => ReportIncidentPlanListBloc(),
        ),
        BlocProvider<ReportIncidentCreateBloc>(
          create: (context) => ReportIncidentCreateBloc(),
        ),
        BlocProvider<NotificationBloc>(
          create: (context) => NotificationBloc(),
        ),
        BlocProvider<NotificationListBloc>(
          create: (context) => NotificationListBloc(),
        ),
        BlocProvider<ChatMenuBadgeCountBloc>(
          create: (context) => ChatMenuBadgeCountBloc(),
        ),
      ],
      child: child,
    );
  }
}
