part of 'logout_bloc.dart';

abstract class LogoutState extends Equatable {
  const LogoutState();

  @override
  List<Object> get props => [];
}

class LogoutInitial extends LogoutState {
  @override
  List<Object> get props => [];
}

class LogoutLoading extends LogoutState {}

class LogoutLoaded extends LogoutState {
  final bool result;

  LogoutLoaded({
    this.result,
  });
  // @override
  // List<Object> get props => [result];
}

class LogoutNotFound extends LogoutState {}

class LogoutError extends LogoutState {
  final String message;
  const LogoutError({this.message});
  @override
  List<Object> get props => [message];
}

class LogoutErrorUnauthorized extends LogoutState {}
