part of 'login_bloc.dart';

abstract class LoginState extends Equatable {
  const LoginState();
  @override
  List<Object> get props => [];
}

class LoginInitial extends LoginState {
  @override
  List<Object> get props => [];
}

class LoginLoading extends LoginState {}

class LoginLoaded extends LoginState {
  final bool result;
  final String phoneNumber;
  final OtpModel otpResult;

  LoginLoaded({
    this.result,
    this.phoneNumber,
    this.otpResult,
  });
  @override
  List<Object> get props => [result];
}

class LoginNotFound extends LoginState {}

class LoginError extends LoginState {
  final String message;

  const LoginError({this.message});
  @override
  List<Object> get props => [message];
}
