part of 'history_bill_list_bloc.dart';

abstract class HistoryBillListState extends Equatable {
  const HistoryBillListState();
  @override
  List<Object> get props => [];
}

class HistoryBillListInitial extends HistoryBillListState {
  @override
  List<Object> get props => [];
}

class HistoryBillListLoading extends HistoryBillListState {}

class HistoryBillListLoaded extends HistoryBillListState {
  final List<HistoryBillModel> result;

  HistoryBillListLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class HistoryBillListNotFound extends HistoryBillListState {}

class HistoryBillListError extends HistoryBillListState {
  final String message;
  const HistoryBillListError({this.message});
  @override
  List<Object> get props => [message];
}

class HistoryBillListErrorUnauthorized extends HistoryBillListState {}
