part of 'history_bill_detail_list_bloc.dart';

abstract class HistoryBillDetailListState extends Equatable {
  const HistoryBillDetailListState();
  @override
  List<Object> get props => [];
}

class HistoryBillDetailListInitial extends HistoryBillDetailListState {
  @override
  List<Object> get props => [];
}

class HistoryBillDetailListLoading extends HistoryBillDetailListState {}

class HistoryBillDetailListLoaded extends HistoryBillDetailListState {
  final List<HistoryBillDetailModel> result;
  final bool deleteSuccess;

  HistoryBillDetailListLoaded({
    this.result,
    this.deleteSuccess,
  });
  @override
  List<Object> get props => [result, deleteSuccess];
}

class HistoryBillDetailListNotFound extends HistoryBillDetailListState {}

class HistoryBillDetailListError extends HistoryBillDetailListState {
  final String message;
  const HistoryBillDetailListError({this.message});
  @override
  List<Object> get props => [message];
}

class HistoryBillDetailListErrorUnauthorized extends HistoryBillDetailListState {}
