import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/feedback_type_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/feedback_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'feedback_type_event.dart';
part 'feedback_type_state.dart';

class FeedbackTypeBloc extends Bloc<FeedbackTypeEvent, FeedbackTypeState> {
  FeedbackImpService service = FeedbackImpService();

  ResultData resultData;

  FeedbackTypeBloc() : super(FeedbackTypeInitial());

  @override
  Stream<FeedbackTypeState> mapEventToState(FeedbackTypeEvent event) async* {
    try {
      if (event is FeedbackTypeGetList) {
        yield FeedbackTypeLoading();

        resultData = await service.getFeedbackTypeList(
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield FeedbackTypeErrorUnauthorized();
        } else {
          yield FeedbackTypeLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield FeedbackTypeError(message: "Error");
    }
  }
}
