part of 'feedback_suggestion_type_bloc.dart';

abstract class FeedbackSuggestionTypeState extends Equatable {
  const FeedbackSuggestionTypeState();

  @override
  List<Object> get props => [];
}

class FeedbackSuggestionTypeInitial extends FeedbackSuggestionTypeState {
  @override
  List<Object> get props => [];
}

class FeedbackSuggestionTypeLoading extends FeedbackSuggestionTypeState {}

class FeedbackSuggestionTypeLoaded extends FeedbackSuggestionTypeState {
  final List<FeedbackSuggestionTypeModel> resultSuggestionType;
  final List<FeedbackSubjectSuggestionTypeModel> resultSubjectSuggestionType;

  FeedbackSuggestionTypeLoaded({
    this.resultSuggestionType,
    this.resultSubjectSuggestionType,
  });
  @override
  List<Object> get props => [resultSuggestionType, resultSubjectSuggestionType];
}

class FeedbackSuggestionTypeNotFound extends FeedbackSuggestionTypeState {}

class FeedbackSuggestionTypeError extends FeedbackSuggestionTypeState {
  final String message;
  const FeedbackSuggestionTypeError({this.message});
  @override
  List<Object> get props => [message];
}

class FeedbackSuggestionTypeErrorUnauthorized extends FeedbackSuggestionTypeState {}
