part of 'feedback_save_bloc.dart';

abstract class FeedbackSaveState extends Equatable {
  const FeedbackSaveState();
  @override
  List<Object> get props => [];
}

class FeedbackSaveInitial extends FeedbackSaveState {
  @override
  List<Object> get props => [];
}

class FeedbackSaveLoading extends FeedbackSaveState {}

class FeedbackSaveLoaded extends FeedbackSaveState {
  final bool result;

  FeedbackSaveLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class FeedbackSaveNotFound extends FeedbackSaveState {}

class FeedbackSaveError extends FeedbackSaveState {
  final String message;
  const FeedbackSaveError({this.message});
  @override
  List<Object> get props => [message];
}

class FeedbackSaveErrorUnauthorized extends FeedbackSaveState {}
