part of 'feedback_list_bloc.dart';

abstract class FeedbackListState extends Equatable {
  const FeedbackListState();

  @override
  List<Object> get props => [];
}

class FeedbackListInitial extends FeedbackListState {
  @override
  List<Object> get props => [];
}

class FeedbackListLoading extends FeedbackListState {}

class FeedbackListLoaded extends FeedbackListState {
  final List<FeedbackModel> result;

  FeedbackListLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class FeedbackListNotFound extends FeedbackListState {}

class FeedbackListError extends FeedbackListState {
  final String message;
  const FeedbackListError({this.message});
  @override
  List<Object> get props => [message];
}

class FeedbackListErrorUnauthorized extends FeedbackListState {}
