import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/feedback_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/feedback_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'feedback_list_event.dart';
part 'feedback_list_state.dart';

class FeedbackListBloc extends Bloc<FeedbackListEvent, FeedbackListState> {
  FeedbackImpService service = FeedbackImpService();

  ResultData resultData;

  FeedbackListBloc() : super(FeedbackListInitial());

  @override
  Stream<FeedbackListState> mapEventToState(FeedbackListEvent event) async* {
    try {
      if (event is FeedbackListGetList) {
        yield FeedbackListLoading();

        resultData = await service.getList(
          caNumber: ShareDataUtil.getCaNumber(),
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield FeedbackListErrorUnauthorized();
        } else {
          yield FeedbackListLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield FeedbackListError(message: "Error");
    }
  }
}
