part of 'feedback_detail_bloc.dart';

abstract class FeedbackDetailState extends Equatable {
  const FeedbackDetailState();
  @override
  List<Object> get props => [];
}

class FeedbackDetailInitial extends FeedbackDetailState {
  @override
  List<Object> get props => [];
}

class FeedbackDetailLoading extends FeedbackDetailState {}

class FeedbackDetailLoaded extends FeedbackDetailState {
  final FeedbackDetailModel result;

  FeedbackDetailLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class FeedbackDetailNotFound extends FeedbackDetailState {}

class FeedbackDetailError extends FeedbackDetailState {
  final String message;
  const FeedbackDetailError({this.message});
  @override
  List<Object> get props => [message];
}

class FeedbackDetailErrorUnauthorized extends FeedbackDetailState {}
