import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/feedback_detail_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/feedback_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'feedback_detail_event.dart';
part 'feedback_detail_state.dart';

class FeedbackDetailBloc extends Bloc<FeedbackDetailEvent, FeedbackDetailState> {
  FeedbackImpService service = FeedbackImpService();

  ResultData resultData;
  String feedbackId;

  FeedbackDetailBloc() : super(FeedbackDetailInitial());

  @override
  Stream<FeedbackDetailState> mapEventToState(FeedbackDetailEvent event) async* {
    try {
      if (event is FeedbackDetailAddId) {
        feedbackId = event.feedbackId;
      } else if (event is FeedbackDetailGetData) {
        yield FeedbackDetailLoading();

        resultData = await service.getDetail(
          feedbackId: feedbackId,
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield FeedbackDetailErrorUnauthorized();
        } else {
          yield FeedbackDetailLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield FeedbackDetailError(message: "Error");
    }
  }
}
