part of 'electricity_statistic_type_list_bloc.dart';

abstract class ElectricityStatisticTypeListState extends Equatable {
  const ElectricityStatisticTypeListState();

  @override
  List<Object> get props => [];
}

class ElectricityStatisticTypeListInitial extends ElectricityStatisticTypeListState {
  @override
  List<Object> get props => [];
}

class ElectricityStatisticTypeListLoading extends ElectricityStatisticTypeListState {}

class ElectricityStatisticTypeListLoaded extends ElectricityStatisticTypeListState {
  final List<ElectricityStatisticTypeModel> result;

  ElectricityStatisticTypeListLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class ElectricityStatisticTypeListNotFound extends ElectricityStatisticTypeListState {}

class ElectricityStatisticTypeListError extends ElectricityStatisticTypeListState {
  final String message;
  const ElectricityStatisticTypeListError({this.message});
  @override
  List<Object> get props => [message];
}

class ElectricityStatisticTypeListErrorUnauthorized extends ElectricityStatisticTypeListState {}
