import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/electricity_statistic_type_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/electricity_statistic_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'electricity_statistic_type_list_event.dart';
part 'electricity_statistic_type_list_state.dart';

class ElectricityStatisticTypeListBloc extends Bloc<ElectricityStatisticTypeListEvent, ElectricityStatisticTypeListState> {
  ElectricityStatisticImpService service = ElectricityStatisticImpService();

  ResultData resultData;

  ElectricityStatisticTypeListBloc() : super(ElectricityStatisticTypeListInitial());

  @override
  Stream<ElectricityStatisticTypeListState> mapEventToState(ElectricityStatisticTypeListEvent event) async* {
    try {
      if (event is ElectricityStatisticTypeListGetList) {
        yield ElectricityStatisticTypeListLoading();
        resultData = await service.getStatisticTypeList(
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield ElectricityStatisticTypeListErrorUnauthorized();
        } else {
          yield ElectricityStatisticTypeListLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield ElectricityStatisticTypeListError(message: "Error");
    }
  }
}
