part of 'electricity_statistic_bloc.dart';

abstract class ElectricityStatisticState extends Equatable {
  const ElectricityStatisticState();

  @override
  List<Object> get props => [];
}

class ElectricityStatisticInitial extends ElectricityStatisticState {
  @override
  List<Object> get props => [];
}

class ElectricityStatisticLoading extends ElectricityStatisticState {}

class ElectricityStatisticLoaded extends ElectricityStatisticState {
  final List<ElectricityStatisticModel> result;

  ElectricityStatisticLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class ElectricityStatisticNotFound extends ElectricityStatisticState {}

class ElectricityStatisticError extends ElectricityStatisticState {
  final String message;
  const ElectricityStatisticError({this.message});
  @override
  List<Object> get props => [message];
}

class ElectricityStatisticErrorUnauthorized extends ElectricityStatisticState {}
