part of 'electricity_location_save_bloc.dart';

abstract class ElectricityLocationSaveState extends Equatable {
  const ElectricityLocationSaveState();

  @override
  List<Object> get props => [];
}

class ElectricityLocationSaveInitial extends ElectricityLocationSaveState {}

class ElectricityLocationSaveLoading extends ElectricityLocationSaveState {}

class ElectricityLocationSaveLoaded extends ElectricityLocationSaveState {
  final bool saveSuccess;

  ElectricityLocationSaveLoaded({this.saveSuccess});
  @override
  List<Object> get props => [saveSuccess];
}

class ElectricityLocationSaveNotFound extends ElectricityLocationSaveState {}

class ElectricityLocationSaveError extends ElectricityLocationSaveState {
  final String message;
  const ElectricityLocationSaveError({this.message});
  @override
  List<Object> get props => [message];
}

class ElectricityLocationSaveErrorUnauthorized extends ElectricityLocationSaveState {}
