part of 'electricity_location_list_bloc.dart';

abstract class ElectricityLocationListState extends Equatable {
  const ElectricityLocationListState();

  @override
  List<Object> get props => [];
}

class ElectricityLocationListInitial extends ElectricityLocationListState {
  @override
  List<Object> get props => [];
}

class ElectricityLocationListLoading extends ElectricityLocationListState {}

class ElectricityLocationListLoaded extends ElectricityLocationListState {
  final List<ElectricityLocationCustomerModel> result;

  ElectricityLocationListLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class ElectricityLocationListNotFound extends ElectricityLocationListState {}

class ElectricityLocationListError extends ElectricityLocationListState {
  final String message;
  const ElectricityLocationListError({this.message});
  @override
  List<Object> get props => [message];
}

class ElectricityLocationListErrorUnauthorized extends ElectricityLocationListState {}
