import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/customer_info_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'customer_info_event.dart';
part 'customer_info_state.dart';

class CustomerInfoBloc extends Bloc<CustomerInfoEvent, CustomerInfoState> {
  ResultData resultData;

  CustomerInfoBloc() : super(CustomerInfoInitial());

  @override
  Stream<CustomerInfoState> mapEventToState(CustomerInfoEvent event) async* {
    try {
      if (event is CustomerInfoGetData) {
        yield CustomerInfoLoading();

        CustomerInfoModel user = await ShareDataUtil.getCustomerInfo();
        await Future.delayed(Duration(milliseconds: 500));

        if (user != null) {
          yield CustomerInfoLoaded(result: user);
        } else {
          yield CustomerInfoError(message: "เกิดข้อผิดพลาด");
        }
      }
    } catch (e) {
      yield CustomerInfoError(message: "เกิดข้อผิดพลาด");
    }
  }
}
